<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'h5p', language 'en', branch 'master'
 *
 * @package   core_h5p
 * @copyright 2019 Moodle
 * @author    Sara Arjona <sara@moodle.com>
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

$string['actions'] = 'Actions';
$string['addedandupdatedpp'] = 'Added {$a->%new} new H5P libraries and updated {$a->%old} old ones.';
$string['addedandupdatedps'] = 'Added {$a->%new} new H5P libraries and updated {$a->%old} old one.';
$string['addedandupdatedsp'] = 'Added {$a->%new} new H5P library and updated {$a->%old} old ones.';
$string['addedandupdatedss'] = 'Added {$a->%new} new H5P library and updated {$a->%old} old one.';
$string['addednewlibraries'] = 'Added {$a->%new} new H5P libraries.';
$string['addednewlibrary'] = 'Added {$a->%new} new H5P library.';
$string['additionallicenseinfo'] = 'Any additional information about the licence';
$string['atto_h5p'] = 'Insert H5P button';
$string['atto_h5p_description'] = 'The Insert H5P button in the Atto editor enables users to insert H5P content by either entering a URL or embed code, or by uploading an H5P file.';
$string['author'] = 'Author';
$string['authorcomments'] = 'Author comments';
$string['authorcommentsdescription'] = 'Comments for the editor of the content. (This text will not be published as a part of the copyright info.)';
$string['authorname'] = 'Author\'s name';
$string['authorrole'] = 'Author\'s role';
$string['by'] = 'by';
$string['cancellabel'] = 'Cancel';
$string['ccattribution'] = 'Attribution (CC BY)';
$string['ccattributionnc'] = 'Attribution-NonCommercial (CC BY-NC)';
$string['ccattributionncnd'] = 'Attribution-NonCommercial-NoDerivs (CC BY-NC-ND)';
$string['ccattributionncsa'] = 'Attribution-NonCommercial-ShareAlike (CC BY-NC-SA)';
$string['ccattributionnd'] = 'Attribution-NoDerivs (CC BY-ND)';
$string['ccattributionsa'] = 'Attribution-ShareAlike (CC BY-SA)';
$string['ccpdd'] = 'Public Domain Dedication (CC0)';
$string['changedby'] = 'Changed by';
$string['changedescription'] = 'Description of change';
$string['changelog'] = 'Changelog';
$string['changeplaceholder'] = 'Photo cropped, text changed, etc.';
$string['close'] = 'Close';
$string['confirmdialogbody'] = 'Please confirm that you wish to proceed. This action cannot be undone.';
$string['confirmdialogheader'] = 'Confirm action';
$string['confirmlabel'] = 'Confirm';
$string['connectionLost'] = 'Connection lost. Results will be stored and sent when the connection is reestablished.';
$string['connectionReestablished'] = 'Connection reestablished.';
$string['contentCopied'] = 'Content is copied to the clipboard';
$string['contentchanged'] = 'This content has changed since you last used it.';
$string['contentinuse'] = 'This content may be in use in other places.';
$string['contenttype'] = 'Content type';
$string['copyright'] = 'Rights of use';
$string['copyrightinfo'] = 'Copyright information';
$string['copyrightstring'] = 'Copyright';
$string['copyrighttitle'] = 'View copyright information for this content.';
$string['couldNotParseJSONFromZip'] = 'Unable to parse JSON from the package: {$a->%fileName}';
$string['couldNotReadFileFromZip'] = 'Unable to read file from the package: {$a->%fileName}';
$string['creativecommons'] = 'Creative Commons';
$string['date'] = 'Date';
$string['deletelibraryconfirm'] = '<p>Are you sure you want to delete version <em>\'{$a->version}\'</em> from library <em>\'{$a->name}\'</em>? It will remove the library and all its uses.</p><p>This operation can not be undone.</p>';
$string['deletelibraryversion'] = 'Delete version';
$string['deleting'] = 'Deleting a library';
$string['description'] = 'Description';
$string['disablefullscreen'] = 'Disable fullscreen';
$string['download'] = 'Download';
$string['downloadtitle'] = 'Download this content as a H5P file.';
$string['editcontent'] = 'Edit H5P content';
$string['editor'] = 'Editor';
$string['embed'] = 'Embed';
$string['embedtitle'] = 'View the embed code for this content.';
$string['error:emptycontentid'] = 'The given URL is incorrect or you cannot edit this file.';
$string['eventh5pviewed'] = 'H5P content viewed';
$string['eventh5pdeleted'] = 'H5P deleted';
$string['feature'] = 'Feature';
$string['fetchtypesfailure'] = 'No information could be obtained on the H5P content types available. H5P repository connection failure';
$string['fileExceedsMaxSize'] = 'One of the files inside the package exceeds the maximum file size allowed. ({$a->%file} {$a->%used} > {$a->%max})';
$string['filter_displayh5p'] = 'Display H5P filter';
$string['filter_displayh5p_description'] = 'The Display H5P filter converts URLs into embedded H5P content.';
$string['fullscreen'] = 'Fullscreen';
$string['gpl'] = 'General Public License v3';
$string['h5p'] = 'H5P';
$string['h5peditor'] = 'H5P editor';
$string['h5ptitle'] = 'Visit h5p.org to check out more content.';
$string['h5pfilenotfound'] = 'H5P file not found';
$string['h5pinvalidurl'] = 'Invalid H5P content URL.';
$string['h5plibraryhandler'] = 'H5P framework handler';
$string['h5plibraryhandler_help'] = 'The H5P framework used to display H5P content. The latest version is recommended.';
$string['h5pprivatefile'] = 'This H5P content can\'t be displayed because you don\'t have access to the .h5p file.';
$string['h5pmanage'] = 'Manage H5P content types';
$string['h5poverview'] = 'H5P overview';
$string['h5ppackage'] = 'H5P content type';
$string['h5ppackage_help'] = 'An H5P content type is a file with an H5P or ZIP extension containing all libraries required to display the content.';
$string['h5psettings'] = 'H5P settings';
$string['hideadvanced'] = 'Hide advanced';
$string['installedcontentlibraries'] = 'Installed H5P libraries';
$string['installedcontenttypes'] = 'Installed H5P content types';
$string['installedh5p'] = 'Installed H5P';
$string['invalidcontextid'] = 'H5P file not found (invalid contextid)';
$string['invalidfile'] = 'File "{$a->%filename}" not allowed. Only files with the following extensions are allowed: {$a->%files-allowed}.';
$string['invalidlanguagefile'] = 'Invalid language file {$a->%file} in library {$a->%library}';
$string['invalidlanguagefile2'] = 'Invalid language file {$a->%languageFile} has been included in the library {$a->%name}';
$string['invalidlibrarydata'] = 'Invalid data provided for {$a->%property} in {$a->%library}';
$string['invalidlibrarydataboolean'] = 'Invalid data provided for {$a->%property} in {$a->%library}. Boolean expected.';
$string['invalidlibraryname'] = 'Invalid library name: {$a->%name}';
$string['invalidlibrarynamed'] = 'The H5P library {$a->%library} used in the content is not valid';
$string['invalidlibraryoption'] = 'Illegal option {$a->%option} in {$a->%library}';
$string['invalidlibraryproperty'] = 'Can\'t read the property {$a->%property} in {$a->%library}';
$string['invalidmainjson'] = 'A valid main h5p.json file is missing';
$string['invalidmultiselectoption'] = 'Invalid selected option in multi-select.';
$string['invalidpackage'] = 'Invalid H5P content type';
$string['invalidselectoption'] = 'Invalid selected option in select.';
$string['invalidsemanticsjson'] = 'Invalid semantics.json file has been included in the library {$a->%name}';
$string['invalidsemanticstype'] = 'H5P internal error: unknown content type "{$a->@type}" in semantics. Removing content!';
$string['invalidstring'] = 'Provided string is not valid according to regexp in semantics. (value: "{$a->%value}", regexp: "{$a->%regexp}")';
$string['librarydirectoryerror'] = 'Library directory name must match machineName or machineName-majorVersion.minorVersion (from library.json). (Directory: {$a->%directoryName} , machineName: {$a->%machineName}, majorVersion: {$a->%majorVersion}, minorVersion: {$a->%minorVersion})';
$string['librariesmanagerdescription'] = '<p>H5P enables users to create interactive content by providing a range of content types.</p><p>To ensure that only trusted H5P content types are used on your site, you need to <i>either</i></p><ul><li>Upload H5P content types from h5p.org <i>or</i></li><li>Enable the scheduled task \'Download available H5P content types from h5p.org\'</li></ul><p>Note that users will only be able to use the H5P content types which are installed on your site.</p>';
$string['license'] = 'Licence';
$string['licenseCC010'] = 'CC0 1.0 Universal (CC0 1.0) Public Domain Dedication';
$string['licenseCC010U'] = 'CC0 1.0 Universal';
$string['licenseCC10'] = '1.0 Generic';
$string['licenseCC20'] = '2.0 Generic';
$string['licenseCC25'] = '2.5 Generic';
$string['licenseCC30'] = '3.0 Unported';
$string['licenseCC40'] = '4.0 International';
$string['licenseGPL'] = 'General Public License';
$string['licenseV1'] = 'Version 1';
$string['licenseV2'] = 'Version 2';
$string['licenseV3'] = 'Version 3';
$string['licensee'] = 'Licensee';
$string['licenseextras'] = 'Licence extras';
$string['licenseversion'] = 'Licence version';
$string['lockh5pdeploy'] = 'This H5P content cannot be accessed because it is being deployed. Please try again later.';
$string['mainlibrarydisabled'] = 'This file can\'t be displayed because its content type is disabled. Please contact your administrator to ask for the content type to be enabled.';
$string['missingcontentfolder'] = 'A valid content folder is missing';
$string['missingcoreversion'] = 'The system was unable to install the {$a->%component} component from the package, as it requires a newer version of the H5P plugin. This site is currently running version {$a->%current}, whereas the required version is {$a->%required} or higher. Please upgrade and then try again.';
$string['missingdependency'] = 'Missing dependency {$a->@dep} required by {$a->@lib}.';
$string['missinglibrary'] = 'Missing required library {$a->@library}';
$string['missinglibraryfile'] = 'The file "{$a->%file}" is missing from library: "{$a->%name}"';
$string['missinglibraryjson'] = 'Could not find library.json file with valid json format for library {$a->%name}';
$string['missinglibraryproperty'] = 'The required property {$a->%property} is missing from {$a->%library}';
$string['missingmbstring'] = 'The mbstring PHP extension is not loaded. It is required for H5P to function properly.';
$string['missinguploadpermissions'] = 'Note that the libraries may exist in the file you uploaded, but you\'re not allowed to upload new libraries. Please contact your administrator.';
$string['nocopyright'] = 'No copyright information available for this content.';
$string['noextension'] = 'The file you uploaded is not a valid HTML5 Package. (It doesn\'t have the .h5p file extension.)';
$string['noh5plibhandlerdefined'] = 'There isn\'t any H5P framework handler installed, so H5P content can\'t be displayed.';
$string['nojson'] = 'The main h5p.json file is not valid';
$string['nopermissiontodeploy'] = 'This file can\'t be displayed because it has been uploaded by a user without the required capability to deploy H5P content.';
$string['nopermissiontoedit'] = 'You do not have permission to edit H5P content.';
$string['notrustablefile'] = 'This file can\'t be displayed because it has been uploaded by a user without the capability to update H5P content types.  Please contact your administrator to ask for the content type to be installed.';
$string['nounzip'] = 'The file you uploaded is not a valid HTML5 Package. (It is not possible to unzip it.)';
$string['offlineDialogBody'] = 'We were unable to send information about your completion of this task. Please check your internet connection.';
$string['offlineDialogHeader'] = 'Your connection to the server was lost';
$string['offlineDialogRetryButtonLabel'] = 'Retry now';
$string['offlineDialogRetryMessage'] = 'Retrying in :num....';
$string['offlineSuccessfulSubmit'] = 'Successfully submitted results.';
$string['originator'] = 'Originator';
$string['pd'] = 'Public Domain';
$string['pddl'] = 'Public Domain Dedication and Licence';
$string['pdm'] = 'Public Domain Mark (PDM)';
$string['pluginname'] = 'H5P Package';
$string['privacy:metadata'] = 'H5P subsystem does not store any personal data.';
$string['resizescript'] = 'Include this script on your website if you want dynamic sizing of the embedded content:';
$string['resubmitScores'] = 'Attempting to submit stored results.';
$string['reuse'] = 'Reuse';
$string['reuseContent'] = 'Reuse content';
$string['reuseDescription'] = 'Reuse this content.';
$string['showadvanced'] = 'Show advanced';
$string['showless'] = 'Show less';
$string['showmore'] = 'Show more';
$string['status'] = 'Status';
$string['size'] = 'Size';
$string['source'] = 'Source';
$string['startingover'] = 'You\'ll be starting over.';
$string['sublevel'] = 'Sublevel';
$string['task_h5p'] = 'H5P scheduled task';
$string['task_h5p_description'] = 'The H5P scheduled task downloads available H5P content types from h5p.org.';
$string['thumbnail'] = 'Thumbnail';
$string['title'] = 'Title';
$string['undisclosed'] = 'Undisclosed';
$string['unpackedFilesExceedsMaxSize'] = 'The total size of the unpacked files exceeds the maximum size allowed. ({$a->%used} > {$a->%max})';
$string['updatedlibraries'] = 'Updated {$a->%old} H5P libraries.';
$string['updatedlibrary'] = 'Updated {$a->%old} H5P library.';
$string['uploadlibraries'] = 'Upload H5P content types';
$string['uploadsuccess'] = 'H5P content types uploaded successfully';
$string['wrongversion'] = 'The version of the H5P library {$a->%machineName} used in this content is not valid. Content contains {$a->%contentLibrary}, but it should be {$a->%semanticsLibrary}.';
$string['year'] = 'Year';
$string['years'] = 'Year(s)';
$string['yearsfrom'] = 'Years (from)';
$string['yearsto'] = 'Years (to)';
